/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class RewardButton
extends Button {
    public final QuestScreen questScreen;
    public final Reward reward;

    public RewardButton(Panel panel, Reward r) {
        super(panel, r.getTitle(), r.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.reward = r;
        this.setSize(18, 18);
    }

    public ITextComponent getTitle() {
        if (this.reward.isTeamReward()) {
            return super.getTitle().func_230532_e_().func_240699_a_(TextFormatting.BLUE);
        }
        return super.getTitle();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.reward);
        if (this.reward.isTeamReward()) {
            Object ingredient;
            Object object;
            if (this.reward.addTitleInMouseOverText()) {
                list.add(this.getTitle());
            }
            if ((object = this.getIngredientUnderMouse()) instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap((Object)object)) instanceof ItemStack && !((ItemStack)ingredient).func_190926_b()) {
                ArrayList list1 = new ArrayList();
                GuiHelper.addStackTooltip((ItemStack)((ItemStack)ingredient), list1);
                list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
            list.blankLine();
            this.reward.addMouseOverText(list);
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.reward.team_reward").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.UNDERLINE}));
        } else {
            if (this.reward.addTitleInMouseOverText()) {
                list.add(this.getTitle());
            }
            this.reward.addMouseOverText(list);
            if (!list.shouldRender()) {
                list.zOffset = 580;
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.exists() || !ClientQuestFile.INSTANCE.self.isCompleted(this.reward.quest)) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.exists()) {
                this.reward.onButtonClicked(this, ClientQuestFile.INSTANCE.self.getClaimType(Minecraft.func_71410_x().field_71439_g.func_110124_au(), this.reward).canClaim());
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            this.questScreen.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.reward);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.reward.getIngredient();
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.self == null) {
            return;
        }
        if (this.questScreen.contextMenu != null) {
            // empty if block
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 200.0);
        RenderSystem.enableBlend();
        boolean completed = false;
        if (this.questScreen.file.self.getClaimType(Minecraft.func_71410_x().field_71439_g.func_110124_au(), this.reward).isClaimed()) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (this.questScreen.file.self.isCompleted(this.reward.quest)) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
        }
        matrixStack.func_227865_b_();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x + 19) - (double)theme.getStringWidth(s) / 2.0, (double)(y + 15), 200.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
            matrixStack.func_227865_b_();
        }
    }
}

